#!/bin/bash
set -euo pipefail

#=============================================================================
# Script: 2-configure-hotspot.sh
# PURPOSE: Configure NetworkManager hotspot with DNS hijacking
#=============================================================================

echo "📡 RKPi5 v2.1 Hotspot Configuration"

nmcli connection delete rapture_kit_hotspot 2>/dev/null || true

sudo mkdir -p /etc/NetworkManager/dnsmasq.d /etc/NetworkManager/dnsmasq-shared.d

sudo tee /etc/NetworkManager/dnsmasq.d/captive-portal.conf >/dev/null <<'EOF'
# RKPi5 Captive Portal DNS Hijacking
address=/#/10.42.0.1
address=/rapturekit.com/10.42.0.1
address=/www.rapturekit.com/10.42.0.1
address=/clients1.google.com/10.42.0.1
address=/clients3.google.com/10.42.0.1
address=/connectivitycheck.gstatic.com/10.42.0.1
address=/connectivitycheck.android.com/10.42.0.1
address=/www.msftconnecttest.com/10.42.0.1
address=/www.msftncsi.com/10.42.0.1
address=/captive.apple.com/10.42.0.1
address=/www.apple.com/10.42.0.1
cache-size=1000
log-queries=no
EOF
sudo cp /etc/NetworkManager/dnsmasq.d/captive-portal.conf /etc/NetworkManager/dnsmasq-shared.d/

if ! grep -q '^dns=dnsmasq' /etc/NetworkManager/NetworkManager.conf; then
sudo awk '1; /\[main\]/{print "dns=dnsmasq"; exit}' /etc/NetworkManager/NetworkManager.conf | sudo tee /etc/NetworkManager/NetworkManager.conf >/dev/null
fi

nmcli connection add type wifi ifname wlan0 mode ap \
con-name "rapture_kit_hotspot" autoconnect yes \
ssid "rapture_kit" 802-11-wireless.band bg \
ipv4.method shared ipv4.address 10.42.0.1/24 \
connection.autoconnect-priority 100

for c in $(nmcli -t -f NAME connection show | grep -v rapture_kit_hotspot); do
[[ "$c" = "lo" ]] && continue
nmcli connection modify "$c" connection.autoconnect-priority -10 2>/dev/null || true
echo " lowered priority: $c"
done

sudo systemctl restart NetworkManager
sleep 5

iwconfig wlan0 2>/dev/null | grep -q "Mode:Master" && echo "✅ Hotspot active" || echo "⚠️ Hotspot initializing"

echo "✅ Hotspot configuration complete"
