#!/bin/bash
set -euo pipefail

#=============================================================================
# Script: 4-finalize-golden-master.sh
# PURPOSE: Final production settings and service enablement
#=============================================================================

echo "🎯 RKPi5 v2.1 Golden Master Finalization"

sudo systemctl enable nginx
sudo systemctl enable NetworkManager
sudo systemctl restart nginx

nmcli connection modify rapture_kit_hotspot connection.autoconnect yes
nmcli connection modify rapture_kit_hotspot connection.autoconnect-priority 100

for conn in $(nmcli -t -f NAME connection show | grep -v rapture_kit_hotspot); do
[[ "$conn" = "lo" ]] && continue
nmcli connection modify "$conn" connection.autoconnect no 2>/dev/null || true
done

sudo systemctl restart NetworkManager
sleep 8

iwconfig wlan0 2>/dev/null | grep -q "Mode:Master" && echo "✅ Hotspot active" || echo "⚠️ Hotspot may need a moment"

echo "✅ Finalization complete"
